<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Authentication_model');
        $this->load->model('Common_model'); 
      
        $this->load->library('form_validation');
        $this->Common_model->setDefaultTimezone();

        if (!$this->session->has_userdata('user_id')) {
            redirect('Authentication/index');
        } 
        $getAccessURL = $this->uri->segment(1);
        if (!in_array($getAccessURL, $this->session->userdata('menu_access'))) {
            redirect('Authentication/userProfile');
        } 
    }

     
    //  .........................................customer feedback ---------------------------------------------
    
     public function customerfeedback() {
          $company_id = $this->session->userdata('company_id');

        $data = array();
          $data['customerfeedback'] = $this->Common_model->getAllByCompanyId($company_id, "tbl_customer_feedback");
        $data['main_content'] = $this->load->view('customer/feedback', $data, TRUE);
        $this->load->view('userHome', $data);
        
    }
    
     public function deletecustomerfeedback($id)
     {
           $id = $this->custom->encrypt_decrypt($id, 'decrypt');

        $this->Common_model->deleteStatusChange($id, "tbl_customer_feedback");

        $this->session->set_flashdata('exception',lang('delete_success'));
        redirect('Customer/customerfeedback');
     }
     
       public function addcustomerfeedback($encrypted_id = ""){
         

        $data = array();
        $id = $this->custom->encrypt_decrypt($encrypted_id, 'decrypt');
         $company_id = $this->session->userdata('company_id');
         
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', lang('name'), 'required');
           
            $this->form_validation->set_rules('email', lang('email'), 'required');
            $this->form_validation->set_rules('phone', lang('phone'), 'required');
            $this->form_validation->set_rules('comment', lang('comment'), 'required');
   
            if ($this->form_validation->run() == TRUE) {
                $fmc_info = array();
                $fmc_info['name'] = htmlspecialchars($this->input->post($this->security->xss_clean('name')));
                
                $fmc_info['email'] = $this->input->post($this->security->xss_clean('email'));
                $fmc_info['phone'] = $this->input->post($this->security->xss_clean('phone'));
                  $fmc_info['comment'] = htmlspecialchars($this->input->post($this->security->xss_clean('comment')));
                $fmc_info['user_id'] = $this->session->userdata('user_id');
                $fmc_info['company_id'] = $this->session->userdata('company_id');
                if ($id == "") {
                    $this->Common_model->insertInformation($fmc_info, "tbl_customer_feedback");
                    $this->session->set_flashdata('exception', lang('insertion_success'));
                } else {
                    $this->Common_model->updateInformation($fmc_info, $id, "tbl_customer_feedback");
                    $this->session->set_flashdata('exception', lang('update_success'));
                }
                redirect('Customer/customerfeedback');
            } else {
                if ($id == "") {
                    $data = array();
                    $data['main_content'] = $this->load->view('customer/addfeedback', $data, TRUE);
                    $this->load->view('userHome', $data);
                } else {
                    $data = array();
                    $data['encrypted_id'] = $encrypted_id;
                    
                        
                          $data['cust_feed'] = $this->Common_model->getDataById($id, "tbl_customer_feedback");
                    $data['main_content'] = $this->load->view('customer/editfeedback', $data, TRUE);
                    $this->load->view('userHome', $data);
                }
            }
        } else {
            if ($id == "") {
                $data = array();
               
                $data['main_content'] = $this->load->view('customer/addfeedback', $data, TRUE);
                $this->load->view('userHome', $data);
            } else {
                $data = array();
                
                $data['encrypted_id'] = $encrypted_id;
              
                   $data['cust_feed'] = $this->Common_model->getDataById($id, "tbl_customer_feedback");
                   
                $data['main_content'] = $this->load->view('customer/editfeedback', $data, TRUE);
                $this->load->view('userHome', $data);
            }
        }
        
      
    }
    
    
    
    // ---------------------------------customer feedback end ==----------------------------------------------
}
